/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.tileentity;

import com.dynious.soundscool.SoundsCool;
import com.dynious.soundscool.handler.SoundHandler;
import com.dynious.soundscool.helper.SoundHelper;
import com.dynious.soundscool.network.packet.client.SoundPlayerSelectPacket;
import com.dynious.soundscool.network.packet.server.ServerPlaySoundPacket;
import com.dynious.soundscool.network.packet.server.StopSoundPacket;
import com.dynious.soundscool.sound.Sound;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileSoundPlayer
extends TileEntity {
    private boolean isPowered = false;
    private Sound selectedSound;
    private String lastSoundIdentifier;
    private long timeSoundFinishedPlaying;

    public void setPowered(boolean powered) {
        if (!this.isPowered && powered) {
            this.playCurrentSound();
            this.isPowered = true;
        } else if (this.isPowered && !powered) {
            this.isPowered = false;
        }
    }

    public void selectSound(String soundName) {
        this.selectedSound = SoundHandler.getSound(soundName);
        if (this.func_145831_w().field_72995_K) {
            SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new SoundPlayerSelectPacket(this)});
        }
    }

    public Sound getSelectedSound() {
        return this.selectedSound;
    }

    public void playCurrentSound() {
        if (this.selectedSound != null) {
            if (this.timeSoundFinishedPlaying < System.currentTimeMillis()) {
                if (SoundHandler.getSound(this.selectedSound.getSoundName()) != null) {
                    this.lastSoundIdentifier = UUID.randomUUID().toString();
                    SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
                    SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
                    SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new ServerPlaySoundPacket(this.selectedSound.getSoundName(), this.lastSoundIdentifier, this.field_145851_c, this.field_145848_d, this.field_145849_e)});
                    this.timeSoundFinishedPlaying = (long)(SoundHelper.getSoundLength(this.selectedSound.getSoundLocation()) * 1000.0) + System.currentTimeMillis();
                } else {
                    this.selectedSound = null;
                }
            } else {
                this.stopCurrentSound();
            }
        }
    }

    public void stopCurrentSound() {
        if (System.currentTimeMillis() < this.timeSoundFinishedPlaying) {
            SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            SoundsCool.proxy.getChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
            SoundsCool.proxy.getChannel().writeOutbound(new Object[]{new StopSoundPacket(this.lastSoundIdentifier)});
            this.timeSoundFinishedPlaying = 0L;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.selectedSound = SoundHandler.getSound(compound.func_74779_i("selectedSound"));
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.selectedSound != null) {
            compound.func_74778_a("selectedSound", this.selectedSound.getSoundName());
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        String soundName = pkt.func_148857_g().func_74779_i("selected");
        this.selectedSound = SoundHandler.getSound(soundName);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.selectedSound != null) {
            compound.func_74778_a("selectedSound", this.selectedSound.getSoundName());
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }
}

